<?php 
session_start();
include 'conexao.php';

// Carregar turmas
$turmas = [];
$res = $conn->query("SELECT id, nome FROM turmas ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $turmas[] = $row;
}

// Carregar disciplinas
$disciplinas = [];
$resDisciplinas = $conn->query("SELECT nome FROM disciplinas ORDER BY nome");
while ($row = $resDisciplinas->fetch_assoc()) {
    $disciplinas[] = $row['nome'];
}

// Dados do aluno a editar
$aluno_editando = [];
$turma_selecionada = $_GET['turma_id'] ?? 0;
$editar_id = $_GET['editar_id'] ?? null;

if ($editar_id) {
    $stmt = $conn->prepare("SELECT * FROM alunos WHERE id = ?");
    $stmt->bind_param("i", $editar_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $aluno_editando = $res->fetch_assoc();
}

// Processamento do formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? '';
    $aluno_id = $_POST['aluno_id'] ?? null;
    $nome = $_POST['nome'] ?? '';
    $curso = $_POST['curso'] ?? '';
    $turma_id = $_POST['turma'] ?? null;
    $classe = $_POST['classe'] ?? '';
    $sala = $_POST['sala'] ?? '';
    $idade = $_POST['idade'] ?? '';
    $genero = $_POST['genero'] ?? '';
    $nome_pai = $_POST['nome_pai'] ?? '';
    $nome_mae = $_POST['nome_mae'] ?? '';
    $nascimento = $_POST['nascimento'] ?? null;
    $naturalidade = $_POST['naturalidade'] ?? '';
    $bi = $_POST['bi'] ?? '';
    $bi_emissao_local = $_POST['bi_emissao_local'] ?? '';
    $bi_emissao_data = $_POST['bi_emissao_data'] ?? null;
    $ano_lectivo = $_POST['ano_lectivo'] ?? '';
    $foto = '';

    // Upload de foto
    if (!empty($_FILES['foto']['name'])) {
        $foto_nome = time() . '_' . $_FILES['foto']['name'];
        $destino = 'fotos/' . $foto_nome;
        if (move_uploaded_file($_FILES['foto']['tmp_name'], $destino)) {
            $foto = $foto_nome;
        }
    }

    // AÇÃO: SALVAR
    if ($acao === 'salvar') {
        // Verificar se o nome já existe
        $verifica = $conn->prepare("SELECT id FROM alunos WHERE nome = ?");
        $verifica->bind_param("s", $nome);
        $verifica->execute();
        $verifica->store_result();

        if ($verifica->num_rows === 0) {
            $stmt = $conn->prepare("INSERT INTO alunos 
                (nome, curso, turma_id, classe, sala, idade, genero, nome_pai, nome_mae, nascimento, naturalidade, bi, bi_emissao_local, bi_emissao_data, foto) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("ssississsssssss", $nome, $curso, $turma_id, $classe, $sala, $idade, $genero,
                $nome_pai, $nome_mae, $nascimento, $naturalidade, $bi, $bi_emissao_local, $bi_emissao_data, $foto);
            $stmt->execute();
            $novo_aluno_id = $stmt->insert_id;

            // Buscar turno
            $stmtTurno = $conn->prepare("SELECT turno FROM turmas WHERE id = ?");
            $stmtTurno->bind_param("i", $turma_id);
            $stmtTurno->execute();
            $resTurno = $stmtTurno->get_result();
            $turno = $resTurno->fetch_assoc()['turno'] ?? '';

            // Calcular ordem
            $ordem = 1;
            $stmt_ordem = $conn->prepare("SELECT id FROM alunos WHERE turma_id = ? ORDER BY nome ASC");
            $stmt_ordem->bind_param("i", $turma_id);
            $stmt_ordem->execute();
            $result_ordem = $stmt_ordem->get_result();
            while ($row = $result_ordem->fetch_assoc()) {
                if ($row['id'] == $novo_aluno_id) break;
                $ordem++;
            }

            // Inserir matrícula
            $stmtMatricula = $conn->prepare("INSERT INTO matriculas 
                (aluno_id, turma_id, curso, classe, numero, sala, turno, ano_lectivo) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmtMatricula->bind_param("iississs", $novo_aluno_id, $turma_id, $curso, $classe, $ordem, $sala, $turno, $ano_lectivo);
            $stmtMatricula->execute();

            // Gerar senha
            $senha_cripto = password_hash(strval($ordem), PASSWORD_DEFAULT);
            $stmt_update = $conn->prepare("UPDATE alunos SET senha = ? WHERE id = ?");
            $stmt_update->bind_param("si", $senha_cripto, $novo_aluno_id);
            $stmt_update->execute();

            header("Location: cadastrar_aluno2.php?turma_id=$turma_id");
            exit;
        }
    }

    // AÇÃO: ALTERAR
    if ($acao === 'alterar' && $aluno_id) {
        $query = "UPDATE alunos SET nome=?, curso=?, turma_id=?, classe=?, sala=?, idade=?, genero=?, 
            nome_pai=?, nome_mae=?, nascimento=?, naturalidade=?, bi=?, bi_emissao_local=?, bi_emissao_data=?";
        $params = [$nome, $curso, $turma_id, $classe, $sala, $idade, $genero, 
                   $nome_pai, $nome_mae, $nascimento, $naturalidade, $bi, $bi_emissao_local, $bi_emissao_data];
        $types = "ssississssssss";

        if ($foto !== '') {
            $query .= ", foto=?";
            $params[] = $foto;
            $types .= "s";
        }

        $query .= " WHERE id=?";
        $params[] = $aluno_id;
        $types .= "i";

        $stmt = $conn->prepare($query);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();

        header("Location: cadastrar_aluno2.php?turma_id=$turma_id");
        exit;
    }

    // AÇÃO: APAGAR
    if ($acao === 'apagar' && $aluno_id) {
        $stmt = $conn->prepare("DELETE FROM alunos WHERE id = ?");
        $stmt->bind_param("i", $aluno_id);
        $stmt->execute();
        header("Location: cadastrar_aluno2.php?turma_id=$turma_id");
        exit;
    }
}

// Listar alunos da turma
$alunos = [];
if ($turma_selecionada > 0) {
    $stmt = $conn->prepare("SELECT a.*, t.nome AS turma_nome FROM alunos a 
        LEFT JOIN turmas t ON a.turma_id = t.id 
        WHERE a.turma_id = ? ORDER BY a.nome");
    $stmt->bind_param("i", $turma_selecionada);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $alunos[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>SISMAG — Cadastrar Aluno</title>
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: #f4f6f9; display: flex; flex-direction: column; }
        .sidebar { width: 260px; background: #001f3f; color: white; min-height: 100vh; position: fixed; top: 0; left: 0; padding-top: 60px; }
        .sidebar ul { list-style: none; padding: 0; }
        .sidebar li { padding: 12px 20px; cursor: pointer; border-left: 4px solid transparent; transition: 0.3s; }
        .sidebar li:hover, .sidebar li.active { background: #0056b3; border-left: 4px solid white; }
        .main-header { position: fixed; top: 0; left: 260px; right: 0; background: #003366; color: white; display: flex; justify-content: space-between; align-items: center; height: 60px; padding: 0 20px; z-index: 1000; }
        .form-wrapper { margin-left: 260px; margin-top: 60px; padding: 20px; background: #e0e0e0; min-height: 100vh; }
        form { background: white; padding: 20px; border-radius: 10px; display: flex; flex-wrap: wrap; gap: 15px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        label { font-weight: bold; }
        input, select { width: 100%; padding: 6px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; }
        .form-group { width: calc(50% - 10px); }
        .form-group.full { width: 100%; }
        .buttons { display: flex; gap: 10px; margin-top: 20px; width: 100%; flex-wrap: wrap; }
        button { padding: 8px 16px; border: none; border-radius: 6px; font-weight: bold; cursor: pointer; }
        .save { background: #28a745; color: white; }
        .edit { background: #ffc107; color: black; }
        .delete { background: #dc3545; color: white; }
        table { margin-top: 30px; width: 100%; background: white; border-collapse: collapse; }
        th, td { padding: 10px; text-align: center; border: 1px solid #ccc; }
        th { background: #003366; color: white; }
    </style>
</head>
<body>
<aside class="sidebar">
    <ul>
        <li onclick="window.location.href='painel_secretaria_geral.php'"><i class="fas fa-home"></i> Voltar ao Painel</li>
        <li class="active"><i class="fas fa-user-graduate"></i> Alunos</li>
        <li onclick="mostrarSecao('secaoTurmas')"><i class="fas fa-layer-group"></i> Turmas</li>
        <li onclick="mostrarSecao('secaoDisciplinas')"><i class="fas fa-book"></i> Disciplinas</li>
    </ul>
</aside>

<div class="main-header">
    <div>SISMAG — Cadastrar Aluno</div>
    <div>Usuário: <?= $_SESSION['usuario']['nome'] ?? 'Desconhecido' ?></div>
</div>

<div class="form-wrapper">
    <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="aluno_id" id="aluno_id">

        <div class="form-group full">
    <label for="nome">Nome</label>
    <input type="text" name="nome" id="nome" required value="<?= $aluno_editando['nome'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="nome_pai">Nome do Pai</label>
    <input type="text" name="nome_pai" id="nome_pai" value="<?= $aluno_editando['nome_pai'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="nome_mae">Nome da Mãe</label>
    <input type="text" name="nome_mae" id="nome_mae" value="<?= $aluno_editando['nome_mae'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="nascimento">Data de Nascimento</label>
    <input type="date" name="nascimento" id="nascimento" value="<?= $aluno_editando['nascimento'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="naturalidade">Naturalidade</label>
    <input type="text" name="naturalidade" id="naturalidade" value="<?= $aluno_editando['naturalidade'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="bi">Nº do BI</label>
    <input type="text" name="bi" id="bi" value="<?= $aluno_editando['bi'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="bi_emissao_local">Emitido em</label>
    <input type="text" name="bi_emissao_local" id="bi_emissao_local" value="<?= $aluno_editando['bi_emissao_local'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="bi_emissao_data">Data de Emissão</label>
    <input type="date" name="bi_emissao_data" id="bi_emissao_data" value="<?= $aluno_editando['bi_emissao_data'] ?? '' ?>">
</div>

<div class="form-group">
    <label for="foto">Foto do Aluno</label>
    <input type="file" name="foto" accept="image/*">
</div>
<div class="form-group">
    <label for="curso">Curso</label>
    <select name="curso" id="curso">
        <option value="">-- Selecionar --</option>
        <option value="CH" <?= (isset($aluno_editando['curso']) && $aluno_editando['curso'] == 'CH') ? 'selected' : '' ?>>CH</option>
        <option value="CEJ" <?= (isset($aluno_editando['curso']) && $aluno_editando['curso'] == 'CEJ') ? 'selected' : '' ?>>CEJ</option>
        <option value="REGULAR" <?= (isset($aluno_editando['curso']) && $aluno_editando['curso'] == 'REGULAR') ? 'selected' : '' ?>>REGULAR</option>
    </select>
</div>
<div class="form-group">
    <label for="turma">Turma</label>
    <select name="turma" id="turma" onchange="filtrarPorTurma()">
        <option value="">-- Selecionar --</option>
        <?php foreach ($turmas as $t): 
            $selecionado = '';
            if (
                (isset($aluno_editando['turma_id']) && $aluno_editando['turma_id'] == $t['id']) || 
                (!isset($aluno_editando['turma_id']) && $turma_selecionada == $t['id'])
            ) {
                $selecionado = 'selected';
            }
        ?>
            <option value="<?= htmlspecialchars($t['id']) ?>" <?= $selecionado ?>>
                <?= htmlspecialchars($t['nome']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<div class="form-group">
    <label for="classe">Classe</label>
    <select name="classe" id="classe">
        <option value="">-- Selecionar --</option>
        <?php foreach (['7ª', '8ª', '10ª', '11ª', '12ª'] as $classe): ?>
           <option value="<?= $classe ?>" <?= (isset($aluno_editando['classe']) && $aluno_editando['classe'] == $classe) ? 'selected' : '' ?>>

                <?= $classe ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<div class="form-group">
    <label for="sala">Nº da Sala</label>
    <select name="sala" id="sala">
        <option value="">-- Selecionar --</option>
        <?php for ($i = 1; $i <= 15; $i++): ?>
          <option value="<?= $i ?>" <?= (isset($aluno_editando['sala']) && $aluno_editando['sala'] == $i) ? 'selected' : '' ?>>
    <?= $i ?>
</option>

                <?= $i ?>
            </option>
        <?php endfor; ?>
    </select>
</div>

<div class="form-group">
    <label for="idade">Idade</label>
    <select name="idade" id="idade" required>
        <option value="">-- Selecionar --</option>
        <?php for ($i = 11; $i <= 25; $i++): ?>
           <option value="<?= $i ?>" <?= (isset($aluno_editando['idade']) && $aluno_editando['idade'] == $i) ? 'selected' : '' ?>>

                <?= $i ?> anos
            </option>
        <?php endfor; ?>
    </select>
</div>

<div class="form-group">
    <label for="ano_lectivo">Ano Lectivo</label>
    <select name="ano_lectivo" id="ano_lectivo" required>
      <option value="" <?= (!isset($aluno_editando['sala']) || $aluno_editando['sala'] == '') ? 'selected' : '' ?>>-- Selecionar --</option>

        <?php for ($ano = 2024; $ano <= 2035; $ano++):
            $valor = "$ano/" . ($ano + 1); ?>
            <option value="<?= $valor ?>" <?= (isset($aluno_editando['ano_lectivo']) && $aluno_editando['ano_lectivo'] == $valor) ? 'selected' : '' ?>>

                <?= $valor ?>
            </option>
        <?php endfor; ?>
    </select>
</div>

<div class="form-group">
    <label for="genero">Género</label>
    <select name="genero" id="genero">
        <option value="Masculino" <?= (isset($aluno_editando['genero']) && $aluno_editando['genero'] == 'Masculino') ? 'selected' : '' ?>>Masculino</option>
<option value="Feminino" <?= (isset($aluno_editando['genero']) && $aluno_editando['genero'] == 'Feminino') ? 'selected' : '' ?>>Feminino</option>

    </select>
</div>



        <div class="buttons">
            <button class="save" type="submit" name="acao" value="salvar">Salvar</button>
            <button class="edit" type="submit" name="acao" value="alterar">Alterar</button>
            <button class="delete" type="submit" name="acao" value="apagar">Apagar</button>
        </div>
    </form>

    <div id="secaoTurmas" style="display:none; margin-top:20px; background:white; padding:20px; border-radius:10px;">
        <h3>📘 Lista de Turmas</h3>
        <ul>
            <?php foreach ($turmas as $t): ?>
                <li><a href="?turma_id=<?= $t['id'] ?>" style="color:#0056b3; font-weight:bold;"><?= htmlspecialchars($t['nome']) ?></a></li>
            <?php endforeach; ?>
        </ul>
    </div>

    <div id="secaoDisciplinas" style="display:none; margin-top:20px; background:white; padding:20px; border-radius:10px;">
        <h3>📚 Disciplinas Cadastradas</h3>
        <ul>
            <?php foreach ($disciplinas as $d): ?>
                <li><?= htmlspecialchars($d) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>

    <?php if ($turma_selecionada > 0): ?>
        <h3>Lista de Alunos da Turma Selecionada</h3>
        <table>
            <thead>
                <tr><th>Nº</th><th>Nome</th><th>Idade</th><th>Género</th><th>Curso</th><th>Acções</th></tr>
            </thead>
            <tbody>
            <?php $i=1; foreach ($alunos as $a): ?>
                <tr>
                    <td><?= $i++ ?></td>
                   <td>
  <a href="cadastrar_aluno2.php?turma_id=<?= $turma_selecionada ?>&editar_id=<?= $a['id'] ?>" style="color:#003366; font-weight:bold;">
    <?= htmlspecialchars($a['nome']) ?>
  </a>
</td>

                    <td><?= $a['idade'] ?></td>
                    <td><?= $a['genero'] ?></td>
                    <td><?= $a['curso'] ?></td>
                    <td><button type="button" onclick='editarAluno(<?= json_encode($a) ?>)' style="background:#ffc107; border:none; border-radius:5px;">Editar</button></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <a href="imprimir_lista_antigos.php?turma_id=<?= $turma_selecionada ?>" target="_blank">
            <button style="margin-top:10px; padding:10px 20px; background:green; color:white; border:none; border-radius:5px;">
                🖨️ Imprimir Lista
            </button>
        </a>
    <?php endif; ?>
</div>

<script>
function editarAluno(aluno) {
    document.getElementById('nome').value = aluno.nome || '';
    document.getElementById('nome_pai').value = aluno.nome_pai || '';
    document.getElementById('nome_mae').value = aluno.nome_mae || '';
    document.getElementById('nascimento').value = aluno.nascimento || '';
    document.getElementById('naturalidade').value = aluno.naturalidade || '';
    document.getElementById('bi').value = aluno.bi || '';
    document.getElementById('bi_emissao_local').value = aluno.bi_emissao_local || '';
    document.getElementById('bi_emissao_data').value = aluno.bi_emissao_data || '';
    document.getElementById('genero').value = aluno.genero || '';
    document.getElementById('idade').value = aluno.idade || '';
    document.getElementById('sala').value = aluno.sala || '';
    document.getElementById('classe').value = aluno.classe || '';
    document.getElementById('curso').value = aluno.curso || '';
    document.getElementById('ano_lectivo').value = aluno.ano_lectivo || '';
    document.getElementById('turma').value = aluno.turma_id || '';
    document.getElementById('aluno_id').value = aluno.id || '';

    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function filtrarPorTurma() {
    var turmaId = document.getElementById('turma').value;
    if (turmaId) {
        window.location.href = 'cadastrar_aluno2.php?turma_id=' + turmaId;
    }
}

function mostrarSecao(secaoId) {
    document.getElementById('secaoTurmas').style.display = 'none';
    document.getElementById('secaoDisciplinas').style.display = 'none';
    document.getElementById(secaoId).style.display = 'block';
}
</script>
</body>
</html>
